#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, print_function, absolute_import

from barman import xlog
import sys
import os
import binascii
import time

from barman.config import Config
from barman.server import Server

ret = 0
msg = ''


def die(ret=0, msg=''):
    with open('/tmp/check_xlogs.status', 'w') as f:
        f.write('%d;%d;%s\n' % (int(time.time()), ret, msg))
    print('%d:%s' % (ret, msg))
    sys.exit(0)


def iterWals(start, end):
    startTli, startLog, startSeg = xlog.decode_segment_name(start)
    endTli, endLog, endSeg = xlog.decode_segment_name(end)

    for i in xrange(startLog, endLog+1):
        jStart = 0
        jEnd = 256
        if i == startLog:
            jStart = startSeg
        if i == endLog:
            jEnd = endSeg + 1
        for j in xrange(jStart, jEnd):
            yield xlog.encode_segment_name(startTli, i, j)


def checkWalFile(walsDir, wal):
    tli, log, _ = xlog.decode_segment_name(wal)
    dirPath = os.path.join(walsDir, "%08X%08X" % (tli, log))
    path = os.path.join(dirPath, wal)
    if os.path.exists(path):
        try:
            with open(path, 'rb') as f:
                if binascii.b2a_hex(f.read(4)) in ('1f8b0800', '1f8b0808'):
                    return True
        except Exception:
            print('unable to open ' + path)
            return False

        if os.path.getsize(path) == 16777216:
            return True
        else:
            print('incorrect size ' + path)
            return False

    print(path + ' not found')
    return False

c = Config('/etc/barman.conf')
c.load_configuration_files_directory()

for server in [x.name for x in c.servers()]:
    print('Checking ' + server)
    s = Server(c.get_server(server))
    lastBackup = s.get_last_backup_id(status_filter=('DONE',))

    b = s.get_backup(lastBackup)
    if b is None:
        continue

    startWal = b.begin_wal

    walsInDB = [x.name for x in s.get_wal_until_next_backup(b)]
    walsDir = s.config.wals_directory

    endWal = ''
    try:
        endWal = walsInDB[-1]
    except Exception:
        if ret == 0:
            ret = 1
        msg += 'Corrupted xlog.db for %s. ' % (server)
        continue

    if xlog.decode_segment_name(startWal)[0] != \
            xlog.decode_segment_name(endWal)[0]:
        if ret == 0:
            ret = 1
        msg += 'Timeline switched for %s. Not checking its xlogs. ' % (server)
        continue

    dbMissing = 0
    fileMissing = 0

    for log in iterWals(startWal, endWal):
        if log not in walsInDB:
            dbMissing += 1
        if not checkWalFile(walsDir, log):
            fileMissing += 1

    if dbMissing != 0:
        if ret == 0:
            ret = 1
        msg += 'Missing %d xlogs in xlog.db on %s. ' % (dbMissing, server)

    if fileMissing != 0:
        ret = 2
        msg += 'Missing %d xlogs on %s. ' % (fileMissing, server)

if msg == '':
    msg = 'OK'

die(ret, msg)
