#!/usr/bin/python

import datetime
import multiprocessing
import subprocess

MAX_PROCESSES = {{ salt['pillar.get']('data:config:max_concurrent_backups', '4')}}

def do_one_backup(cluster):
    cmd = 'barman backup %s' % cluster
    if datetime.datetime.now().weekday() == 6:
        cmd += ' --full'
    res = subprocess.call(cmd.split(), stdout=open('/dev/null', 'a'), stderr=open('/dev/null', 'a'))
    return res

def main():
    cmd = "barman list-server | awk '{print $1}'"
    p = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=open('/dev/null', 'a'))
    clusters = p.communicate()[0].splitlines()

    pool = multiprocessing.Pool(processes=MAX_PROCESSES)
    pool.map(do_one_backup, clusters)

if __name__ == '__main__':
    main()
