include:
    - components.common.dirs

/etc/barman.conf:
    file.managed:
        - template: jinja
        - source: salt://components/pg-barman/conf/barman.conf
        - mode: 644
        - user: root
        - group: root
        - require:
            - pkg: barman

/etc/barman.d:
    file.directory:
        - user: robot-pgbarman
        - group: dpt_virtual_robots
        - mode: 755
        - require:
            - file: /etc/barman.conf
            - cmd: agent.sh

/etc/barman.yandex:
    file.directory:
        - user: robot-pgbarman
        - group: dpt_virtual_robots
        - mode: 755
        - require:
            - file: /etc/barman.d
            - cmd: agent.sh

/home/robot-pgbarman/.ssh:
    file.directory:
        - user: robot-pgbarman
        - group: dpt_virtual_robots
        - mode: 700
        - makedirs: True
        - require_in:
            - /home/robot-pgbarman/.ssh/id_rsa
            - /home/robot-pgbarman/.ssh/id_rsa.pub
        - require:
            - cmd: agent.sh

/home/robot-pgbarman/.ssh/id_rsa:
    file.managed:
        - source: salt://components/pg-barman/conf/id_rsa
        - template: jinja
        - user: robot-pgbarman
        - group: dpt_virtual_robots
        - mode: 600
        - require:
            - cmd: agent.sh

/home/robot-pgbarman/.ssh/id_rsa.pub:
    file.managed:
        - source: salt://components/pg-barman/conf/id_rsa.pub
        - template: jinja
        - user: robot-pgbarman
        - group: dpt_virtual_robots
        - mode: 644
        - require:
            - cmd: agent.sh

/home/robot-pgbarman/.postgresql:
    file.directory:
        - user: robot-pgbarman
        - group: dpt_virtual_robots
        - makedirs: True
        - mode: 755

/home/robot-pgbarman/.postgresql/root.crt:
    file.managed:
        - contents_pillar: cert.ca
        - template: jinja
        - user: robot-pgbarman
        - group: dpt_virtual_robots
        - mode: 600

/root/.postgresql:
    file.directory:
        - makedirs: True
        - mode: 755

/root/.postgresql/root.crt:
    file.managed:
        - contents_pillar: cert.ca
        - template: jinja
        - mode: 600

/var/log/barman:
    file.directory:
        - user: robot-pgbarman
        - group: dpt_virtual_robots
        - mode: 755
        - require:
            - cmd: agent.sh

/var/log/barman/barman.log:
    file.managed:
        - user: robot-pgbarman
        - group: dpt_virtual_robots
        - require:
            - cmd: agent.sh

/etc/cron.d/barman:
    file.managed:
        - source: salt://components/pg-barman/conf/barman.cron.d
        - user: root
        - group: root
        - mode: 644
        - require:
            - pkg: barman
    service.running:
        - name: {{ 'cron' if salt['grains.get']('os') == 'Ubuntu' else 'crond' }}
        - reload: True
        - watch:
            - file: /etc/cron.d/barman

/etc/cron.yandex/change_barman_conf.py:
    file.managed:
        - source: salt://components/pg-barman/conf/change_barman_conf.py
        - user: root
        - group: root
        - mode: 744
        - require:
            - file: /etc/cron.yandex

barman-wal-restore-user:
  user.present:
    - name: barman-wal-restore
    - gid_from_name: True
    - createhome: True
    - empty_password: True
    - shell: /bin/bash

/etc/sudoers.d/barman-wal-restore:
    file.managed:
        - source: salt://components/pg-barman/conf/sudoers-barman-wal-restore
        - user: root
        - mode: 400

/etc/security/local.conf:
    file.managed:
        - source: salt://{{ slspath }}/conf/security-local.conf
        - mode: 600
        - require:
            - pkg: common-packages

/home/barman-wal-restore/.ssh:
    file.directory:
        - user: barman-wal-restore
        - group: barman-wal-restore
        - mode: 700
        - makedirs: True
        - require:
            - cmd: agent.sh
            - user: barman-wal-restore-user

/home/barman-wal-restore/.ssh/authorized_keys:
    file.managed:
        - source: salt://components/pg-barman/conf/id_ecdsa.pub
        - template: jinja
        - user: barman-wal-restore
        - group: barman-wal-restore
        - mode: 755
        - require:
            - file: /home/barman-wal-restore/.ssh

/etc/cron.yandex/do_backups.py:
    file.managed:
        - template: jinja
        - source: salt://components/pg-barman/conf/do_backups.py
        - user: root
        - group: root
        - mode: 755
        - require:
            - file: /etc/cron.yandex

/etc/cron.yandex/check_backup_consistency.py:
    file.managed:
        - source: salt://components/pg-barman/conf/check_backup_consistency.py
        - user: root
        - group: root
        - mode: 755
        - require:
            - file: /etc/cron.yandex

/etc/cron.yandex/check_xlogs.py:
    file.managed:
        - source: salt://components/pg-barman/conf/check_xlogs.py
        - user: root
        - group: root
        - mode: 755
        - require:
            - file: /etc/cron.yandex

/etc/barman-consistency-check.conf:
    file.managed:
        - source: salt://components/pg-barman/conf/check_backup_consistency.conf
        - mode: 644
        - template: jinja

/etc/cron.yandex/barman_cleanup.py:
    file.managed:
        - source: salt://components/pg-barman/conf/barman_cleanup.py
        - mode: 755
        - require:
            - file: /etc/cron.yandex

/usr/local/yandex/barman_switch_xlog.sh:
    file.managed:
        - source: salt://components/pg-barman/conf/barman_switch_xlog.sh
        - user: root
        - group: root
        - mode: 755
        - makedirs: True

/usr/local/yandex/barman_restore_last_backup.py:
    file.managed:
        - source: salt://components/pg-barman/conf/barman_restore_last_backup.py
        - user: root
        - group: root
        - mode: 755
        - makedirs: True

/etc/logrotate.d/barman:
    file.managed:
        - source: salt://components/pg-barman/conf/barman.logrotate.d
        - user: root
        - group: root
        - mode: 644
        - require:
            - pkg: barman
            - pkg: common-packages

/etc/udev/rules.d/90-md-stripe-cache.rules:
    file.managed:
        - source: salt://components/pg-barman/conf/90-md-stripe-cache.rules
        - user: root
        - group: root
        - mode: 644

{% for cluster,config in salt['pillar.get']('data:clusters', {}).iteritems() %}
{% if config['partition'] is defined and config['partition'] != salt['pillar.get']('data:config:barman_path', '/u0/barman').split('/')[1] %}
/{{ config['partition'] }}/{{ cluster }}:
    file.directory:
        - user: robot-pgbarman
        - group: dpt_virtual_robots
        - require_in:
            - file: /etc/barman.yandex/{{ cluster }}.conf
            - file: {{ salt['pillar.get']('data:config:barman_path', '/u0/barman') }}/{{ cluster }}

{{ salt['pillar.get']('data:config:barman_path', '/u0/barman') }}/{{ cluster }}:
    file.symlink:
        - target: /{{ config['partition'] }}/{{ cluster }}
{% endif %}

/etc/barman.yandex/{{ cluster }}.conf:
    file.managed:
        - template: jinja
        - source: salt://components/pg-barman/conf/cluster.conf
        - user: robot-pgbarman
        - group: root
        - mode: 600
        - require:
            - cmd: agent.sh
            - file: /etc/barman.yandex
        - require_in:
            - cmd: update_configs
        - defaults:
            cluster: {{ cluster }}
{% if not 'compression' in config %}
            compression: gzip
{% endif %}
{% for i in config %}
            {{ i }}: {{ config[i] }}
{% endfor %}
{% endfor %}

update_configs:
    cmd.wait:
        - name: rsync --archive --delete /etc/barman.yandex/ /etc/barman.d/ && /etc/cron.yandex/change_barman_conf.py
        - runas: root
        - watch:
            - file: /etc/barman.d
            - file: /etc/cron.yandex/change_barman_conf.py
{% for cluster,config in salt['pillar.get']('data:clusters', {}).iteritems() %}
            - file: /etc/barman.yandex/{{ cluster }}.conf
{% endfor %}
