postgresql-service:
    cmd.wait:
        - name: /bin/true
        - unless: /bin/true

include:
    - components.postgres.pkgs
{% if salt['grains.get']('os') == 'Ubuntu' %}
    - components.postgres.pkgs_ubuntu
{% else %}
    - components.postgres.pkgs_rhel
{% endif %}

exclude:
    - id: yamail-graphite-client-postgres
    - id: yamail-pgswitch
    - id: zk-flock-config-postgres

{% if salt['grains.get']('os') == 'Ubuntu' %}
{%
    set pkgs = {
        'barman': '2.4-29yandex',
        'rsync': '3.1.0-2ubuntu0.4',
        'xinetd': '1:2.3.15-3ubuntu1',
        'lsscsi': '0.27-2',
        'e2fsprogs': '1.42.9-3ubuntu1.3',
        'xfsprogs': '3.1.9ubuntu2.1'
    }
%}
{% else %}
{%
    set pkgs = {
        'barman': '2.1-3yandex.el6',
        'rsync': '3.0.6-12.el6',
        'xinetd': '2.3.14-39.el6_4',
        'lsscsi': '0.23-3.el6',
        'e2fsprogs': '1.42.7-2.el6'
    }
%}
{% endif %}

shelf_tool:
    pkg.removed

{% for package, version in pkgs.items() %}
{% if version == 'any' %}
{{ package }}:
    pkg.installed

{% else %}
{{ package }}:
    pkg.installed:
        - version: {{ version }}
        - ignore_epoch: True
{% if salt['grains.get']('os') == 'Ubuntu' %}
        - require:
            - cmd: yandex-postgresql-stable
{% endif %}

{% endif %}

{% endfor %}
