{% if salt['grains.get']('os') == 'Ubuntu' %}
/etc/xinetd.d/rsync:
    file.replace:
        - name: /etc/default/rsync
        - pattern: 'RSYNC_ENABLE=false'
        - repl: 'RSYNC_ENABLE=true'
        - onlyif:
            - grep -E 'RSYNC_ENABLE=false' /etc/default/rsync
    service.running:
        - name: rsync
        - restart: True
        - require:
            - pkg: xinetd
            - file: /etc/rsyncd.secrets
            - file: /etc/rsyncd.conf
        - watch:
            - file: /etc/default/rsync
{% else %}
/etc/xinetd.d/rsync:
    file.replace:
        - pattern: 'disable\s=\syes'
        - repl: 'disable = no'
        - onlyif:
            - grep -E 'disable\s=\syes' /etc/xinetd.d/rsync
    service.running:
        - name: xinetd
        - restart: True
        - require:
            - pkg: xinetd
        - watch:
            - file: /etc/xinetd.d/rsync
{% endif %}

/etc/rsyncd.conf:
    file.managed:
        - template: jinja
        - source: salt://components/pg-barman/conf/rsyncd.conf
        - user: root
        - group: root
        - mode: 644

/etc/rsyncd.secrets:
    file.managed:
        - source: salt://components/pg-barman/conf/rsyncd.secrets
        - user: root
        - group: root
        - mode: 400
