yasmagent-instance-getter:
    file.managed:
        - name: /usr/local/yasmagent/yasmagent_disk_getter.py
        - template: jinja
        - source: salt://{{ slspath }}/conf/yasm-agent.getter.py
        - makedirs: True
        - mode: 755
        - require:
            - pkg: yasmagent-packages

yasmagent-packages:
    pkg.installed:
        - pkgs:
            - yandex-yasmagent: 2.400-20200121
        - require:
            - pkgrepo: common-stable-all

yasmagent-init:
    file.managed:
        - name: /etc/init.d/yasmagent
        - template: jinja
        - source: salt://{{ slspath }}/conf/yasm-agent.ubuntu.init
        - mode: 755
        - require:
            - pkg: yasmagent-packages

yasmagent-default-config:
    file.managed:
        - name: /etc/default/yasmagent
        - template: jinja
        - source: salt://{{ slspath }}/conf/yasm-agent.default
        - mode: 644

yasmagent-restart:
    service:
        - running
        - enable: true
        - name: yasmagent
        - watch:
            - pkg: yasmagent-packages
            - file: yasmagent-instance-getter
            - file: yasmagent-default-config

/etc/cron.d/yandex-yasmagent:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/cron.d/yandex-yasmagent
        - mode: 644
