CREATE SEQUENCE entity_id_seq;

CREATE TABLE entity (
    id BIGINT NOT NULL DEFAULT nextval('entity_id_seq'),
    external_id TEXT NOT NULL,
    comments_disabled BOOLEAN NOT NULL,

    comments_count INTEGER NOT NULL DEFAULT 0,
    likes_count INTEGER NOT NULL DEFAULT 0,
    dislikes_count INTEGER NOT NULL DEFAULT 0,

    CONSTRAINT pk_entity_id PRIMARY KEY (id),
    CONSTRAINT uk_entity_external_id UNIQUE (external_id),

    CONSTRAINT check_entity_comments_count CHECK (comments_count >= 0),
    CONSTRAINT check_entity_likes_count CHECK (likes_count >= 0),
    CONSTRAINT check_entity_dislikes_count CHECK (dislikes_count >= 0)
);

CREATE SEQUENCE comment_id_seq;

CREATE TABLE comment (
    id BIGINT NOT NULL DEFAULT nextval('comment_id_seq'),
    entity_id BIGINT NOT NULL,
    parent_comment_id BIGINT,

    author_uid BIGINT NOT NULL,
    text TEXT NOT NULL,

    created_at TIMESTAMP NOT NULL,
    edited_at TIMESTAMP,
    deleted_at TIMESTAMP,

    replies_count INTEGER NOT NULL DEFAULT 0,
    likes_count INTEGER NOT NULL DEFAULT 0,
    dislikes_count INTEGER NOT NULL DEFAULT 0,

    CONSTRAINT pk_comment_id PRIMARY KEY (id),
    CONSTRAINT fk_comment_entity_id FOREIGN KEY (entity_id) REFERENCES entity (id),
    CONSTRAINT fk_comment_parent_comment_id FOREIGN KEY (parent_comment_id) REFERENCES comment (id),

    CONSTRAINT check_comment_replies_count CHECK (replies_count >= 0),
    CONSTRAINT check_comment_likes_count CHECK (likes_count >= 0),
    CONSTRAINT check_comment_dislikes_count CHECK (dislikes_count >= 0)
);

CREATE INDEX i_comment_entity_id ON comment (entity_id);

CREATE UNIQUE INDEX uk_comment_entity_id_created_at_for_topic
    ON comment (entity_id, created_at) WHERE parent_comment_id IS NULL;

CREATE UNIQUE INDEX uk_comment_parent_comment_id_created_at_for_reply
    ON comment (parent_comment_id, created_at) WHERE parent_comment_id IS NOT NULL;


CREATE TYPE attitude_type AS ENUM ('like', 'dislike');

CREATE TABLE entity_like_dislike (
    uid BIGINT NOT NULL,
    entity_id BIGINT NOT NULL,

    attitude attitude_type NOT NULL,
    created_at TIMESTAMP NOT NULL,

    CONSTRAINT fk_entity_like_dislike_entity_id FOREIGN KEY (entity_id) REFERENCES entity (id),
    CONSTRAINT uk_entity_like_dislike_uid_entity_id_attitude UNIQUE (uid, entity_id, attitude),
    CONSTRAINT uk_entity_like_dislike_entity_id_attitude_created_at UNIQUE (entity_id, attitude, created_at)
);

CREATE TABLE comment_like_dislike (
    uid BIGINT NOT NULL,
    comment_id BIGINT NOT NULL,

    attitude attitude_type NOT NULL,
    created_at TIMESTAMP NOT NULL,

    CONSTRAINT fk_comment_like_dislike_comment_id FOREIGN KEY (comment_id) REFERENCES comment (id),
    CONSTRAINT uk_comment_like_dislike_uid_comment_id_attitude UNIQUE (uid, comment_id, attitude),
    CONSTRAINT uk_comment_like_dislike_comment_id_attitude_created_at UNIQUE (comment_id, attitude, created_at)
);
