CREATE SCHEMA disk;

CREATE EXTENSION IF NOT EXISTS "uuid-ossp";

CREATE TABLE disk.discount_templates (
    id                    uuid  NOT NULL DEFAULT uuid_generate_v1(),
    description           text,
    provided_line         text,
    disposable            boolean,
    creation_datetime     timestamp with time zone,
    period_timedelta      interval,
    end_datetime          timestamp with time zone,

    CONSTRAINT pk_discount_templates PRIMARY KEY (id)
);

CREATE TABLE disk.discounts_archive (
    id                    uuid  NOT NULL DEFAULT uuid_generate_v1(),
    uid                   bigint,
    discount_template_id  uuid,

    CONSTRAINT pk_discounts_archive PRIMARY KEY (id)
);

CREATE INDEX ix_discounts_archive_uid_discount_template_id on disk.discounts_archive USING btree (uid, discount_template_id);

CREATE TABLE disk.promo_codes (
    id                    text  NOT NULL,
    pid                   text,
    discount_template_id  uuid,
    begin_datetime        timestamp with time zone,
    end_datetime          timestamp with time zone,
    count                 int,

    CONSTRAINT pk_promo_codes PRIMARY KEY (id)
);

CREATE INDEX ix_promo_codes_pid on disk.promo_codes USING btree (pid);

CREATE TABLE disk.promo_codes_archive (
    id                    uuid  NOT NULL DEFAULT uuid_generate_v1(),
    promo_code            text,
    pid                   text,
    sid                   text,
    discount_template_id  uuid,
    activation_datetime   timestamp with time zone,
    uid                   bigint,
    status                text,

    CONSTRAINT pk_promo_codes_archive PRIMARY KEY (id)
);

CREATE INDEX ix_promo_codes_archive_pid on disk.promo_codes_archive USING btree (pid);
CREATE INDEX ix_promo_codes_archive_uid on disk.promo_codes_archive USING btree (uid);
CREATE INDEX ix_promo_codes_archive_promo_code on disk.promo_codes_archive USING btree (promo_code);
