CREATE TABLE IF NOT EXISTS disk.billing_services (
    id                    text NOT NULL DEFAULT uuid_generate_v1(),
    moved                 boolean,
    auto                  boolean,
    btime                 timestamp with time zone,
    buyer_uid             bigint,
    child_sids            text[],
    ctime                 timestamp with time zone,
    description           text,
    dtime                 timestamp with time zone,
    enabled               boolean,
    first_prolongation_fail  int,
    is_group              boolean,
    group_name            text,
    group_uids            bigint[],
    lbtime                timestamp with time zone,
    mtime                 timestamp with time zone,
    notified              int,
    number                text,
    order_id              text,
    original_transaction_id bigint,
    paid_for_other        boolean,
    parent_sid            text,
    pid                   text,
    state                 text,
    uid                   bigint,
    v                     bigint,
    
    CONSTRAINT pk_billing_services PRIMARY KEY (id)
);

CREATE INDEX IF NOT EXISTS ix_billing_services_uid on disk.billing_services USING btree (uid);
CREATE INDEX IF NOT EXISTS ix_billing_services_btime_state on disk.billing_services USING btree (btime, state);
CREATE INDEX IF NOT EXISTS ix_billing_services_btime_pid on disk.billing_services USING btree (btime, pid);
CREATE INDEX IF NOT EXISTS ix_billing_services_original_transaction_id on disk.billing_services USING btree (original_transaction_id);

CREATE TABLE IF NOT EXISTS disk.billing_service_attributes (
    id                    uuid  NOT NULL DEFAULT uuid_generate_v1(),
    amount                bigint,
    uid                   bigint,
    v                     bigint,

    CONSTRAINT pk_billing_service_attributes PRIMARY KEY (id)
);

CREATE INDEX IF NOT EXISTS ix_billing_service_attributes_uid on disk.billing_service_attributes USING btree (uid);

CREATE TABLE IF NOT EXISTS disk.billing_orders_history (
    id                    bytea  NOT NULL,
    moved                 boolean,
    auto                  boolean,
    bb_pid                text,
    ctime                 timestamp with time zone,
    currency              text,
    description           text,
    discount_template_id  uuid,
    fuckup_period         text,
    locale                text,
    market                text,
    mtime                 timestamp with time zone,
    number                text,
    otype                 text,
    payment_id            text,
    payment_method        text,
    pid                   text,
    price                 bigint,
    receipt               text,
    refund_status         text,
    sid                   text,
    state                 text,
    status_code           text,
    trust_refund_id       text,
    uid                   bigint,
    v                     bigint,

    CONSTRAINT pk_billing_orders_history PRIMARY KEY (id)
);

CREATE INDEX IF NOT EXISTS ix_billing_orders_history_uid on disk.billing_orders_history USING btree (uid);
CREATE INDEX IF NOT EXISTS ix_billing_orders_history_ctime on disk.billing_orders_history USING btree (ctime);
CREATE INDEX IF NOT EXISTS ix_billing_orders_history_number on disk.billing_orders_history USING btree (number);

CREATE TABLE IF NOT EXISTS disk.billing_orders (
    id                    text  NOT NULL DEFAULT uuid_generate_v1(),
    auto                  boolean,
    bb_pid                text,
    ctime                 timestamp with time zone,
    currency              text,
    discount_template_id  uuid,           
    group_name            text,
    group_uids            bigint[],
    locale                text,
    market                text,
    mtime                 timestamp with time zone,
    otype                 text,
    payment_id            text,
    payment_method        text,      
    pid                   text,
    price                 bigint,
    sid                   text,
    state                 text,
    uid                   bigint,
    v                     bigint,
    
    CONSTRAINT pk_billing_orders PRIMARY KEY (id)
);

CREATE INDEX IF NOT EXISTS ix_billing_orders_uid on disk.billing_orders USING btree (uid);
CREATE INDEX IF NOT EXISTS ix_billing_orders_ctime on disk.billing_orders USING btree (ctime);

CREATE TABLE IF NOT EXISTS disk.billing_services_history (
    id                    bytea  NOT NULL,
    moved                 boolean,
    auto                  boolean,
    btime                 timestamp with time zone,
    buyer_uid             bigint,
    child_sids            text[],
    ctime                 timestamp with time zone,
    description           text,
    dtime                 timestamp with time zone,
    enabled               boolean,
    first_prolongation_fail       int,        
    free                  boolean,
    is_group                 boolean,
    group_name            text,
    group_uids            bigint[],
    lbtime                timestamp with time zone,
    mtime                 timestamp with time zone,
    notified              int,
    number                text,
    order_id              text,
    original_transaction_id   bigint,       
    paid_for_other        boolean,    
    parent_sid                text,
    pid                   text,
    refund_status         text,
    sid                   text,
    state                 text,
    uid                   bigint,
    v                     bigint,

    CONSTRAINT pk_billing_services_history PRIMARY KEY (id)
);

CREATE INDEX IF NOT EXISTS ix_billing_services_history_uid on disk.billing_services_history USING btree (uid);
CREATE INDEX IF NOT EXISTS ix_billing_services_history_sid on disk.billing_services_history USING btree (sid);


CREATE TABLE IF NOT EXISTS disk.billing_subscriptions (
    id                    text  NOT NULL DEFAULT uuid_generate_v1(),
    ctime                 timestamp with time zone,
    description           text,
    sid                   text,
    uid                   bigint,
    v                     bigint,

    CONSTRAINT pk_billing_subscriptions PRIMARY KEY (id)
);

CREATE INDEX IF NOT EXISTS ix_billing_subscriptions_uid on disk.billing_subscriptions USING btree (uid);
CREATE INDEX IF NOT EXISTS ix_billing_subscriptions_sid on disk.billing_subscriptions USING btree (sid);

CREATE TABLE IF NOT EXISTS disk.billing_locks (
    id                    text  NOT NULL,
    host                  text,
    lock                  int,

    CONSTRAINT pk_billing_locks PRIMARY KEY (id)
);

CREATE TABLE IF NOT EXISTS disk.billing_service_attributes_history (
    id                    uuid  NOT NULL DEFAULT uuid_generate_v1(),
    amount                bigint,
    uid                   bigint,
    v                     bigint,

    CONSTRAINT pk_billing_service_attributes_history PRIMARY KEY (id)
);

CREATE INDEX IF NOT EXISTS ix_billing_service_attributes_history_uid on disk.billing_service_attributes_history USING btree (uid);
