CREATE TABLE disk.groups (
    id                    uuid    NOT NULL DEFAULT uuid_generate_v1(),
    owner                 bigint  NOT NULL,
    path                  text,
    size                  bigint NOT NULL DEFAULT 0,
    version               bigint,

    CONSTRAINT pk_groups PRIMARY KEY (id)
);

CREATE INDEX ix_groups_owner on disk.groups USING btree (owner);

CREATE TABLE disk.group_links (
    id                    uuid    NOT NULL DEFAULT uuid_generate_v1(),
    gid                   uuid    NOT NULL,
    uid                   bigint,
    path                  text,
    version               bigint,
    rights                int     NOT NULL,
    b2b_key               text,
    universe_login        text,
    universe_service      text,
    date_created          timestamp with time zone NOT NULL DEFAULT current_timestamp,

    CONSTRAINT pk_group_links PRIMARY KEY (id)
);

CREATE INDEX ix_group_links_uid on disk.group_links USING btree (uid);

CREATE TABLE disk.group_invites (
    id                    uuid    NOT NULL DEFAULT uuid_generate_v1(),
    gid                   uuid    NOT NULL,
    uid                   bigint,
    name                  text,
    version               bigint,
    rights                int     NOT NULL,
    universe_login        text,
    universe_service      text,
    avatar                text,
    status                text,
    date_created          timestamp with time zone NOT NULL DEFAULT current_timestamp,

    CONSTRAINT pk_group_invites PRIMARY KEY (id)
);

CREATE INDEX ix_group_invites_uid on disk.group_invites USING btree (uid);
CREATE INDEX ix_group_invites_date_created on disk.group_invites USING btree (date_created);
