CREATE TABLE disk.support_blocked_hids (
    id                    bytea  NOT NULL,
    block_type            text,
    ctime                 timestamp with time zone DEFAULT current_timestamp,
    storage_id            uuid    NOT NULL,

    CONSTRAINT pk_support_blocked_hids PRIMARY KEY (id),
    CONSTRAINT uk_support_blocked_hids_storage_id UNIQUE (storage_id)
);

CREATE INDEX ix_support_blocked_hids_storage_id on disk.support_blocked_hids USING btree (storage_id);

CREATE TABLE disk.support_mpfs (
    id                    bytea  NOT NULL,
    data                  jsonb,
    data_id               text,
    data_hash             text,
    data_stids            text[],
    uid                   bigint,

    CONSTRAINT pk_support_mpfs PRIMARY KEY (id)
);

CREATE INDEX ix_support_mpfs_uid on disk.support_mpfs USING btree (uid);
CREATE INDEX ix_support_mpfs_data_id on disk.support_mpfs USING btree (data_id);
CREATE INDEX ix_support_mpfs_data_hash on disk.support_mpfs USING btree (data_hash);
CREATE INDEX ix_support_mpfs_data_stids on disk.support_mpfs USING btree (data_stids);

CREATE TABLE disk.support_prohibited_cleaning_users (
    id                    bytea  NOT NULL,
    comment               text,
    ctime                 timestamp with time zone NOT NULL DEFAULT current_timestamp,
    moderator             text,
    uid                   bigint,

    CONSTRAINT pk_support_prohibited_cleaning_users PRIMARY KEY (id),
    CONSTRAINT uk_support_prohibited_cleaning_users_uid UNIQUE (uid)
);

CREATE INDEX ix_support_prohibited_cleaning_users_uid on disk.support_prohibited_cleaning_users USING btree (uid);

CREATE TABLE disk.support_moderation_queue (
    id                    bytea  NOT NULL,
    created               timestamp with time zone NOT NULL DEFAULT current_timestamp,
    description           text,
    storage_id            uuid    NOT NULL,
    links                 jsonb,
    moderation_time       timestamp with time zone,
    moderator             text,
    source                text,
    status                text,

    CONSTRAINT pk_support_moderation_queue PRIMARY KEY (id)
);

CREATE INDEX ix_support_moderation_queue_storage_id_source on disk.support_moderation_queue USING btree (storage_id, source);

CREATE TABLE disk.support_block_history (
    id                    uuid    NOT NULL DEFAULT uuid_generate_v1(),
    ctime                 timestamp with time zone NOT NULL DEFAULT current_timestamp,
    hids                  text,
    moderator             text,
    public_hashes         text,
    type                  text,
    uids                  text,
    
    CONSTRAINT pk_support_block_history PRIMARY KEY (id)
);
