CREATE TYPE disk.inactive_users_flow_state_type AS ENUM (
    'new',
    'block_warning_1',
    'block_warning_2',
    'blocked',
    'deletion_warning_1',
    'deletion_warning_2',
    'deleted',
    'excluded'
);

CREATE TABLE disk.inactive_users_flow (
    uid bigint  NOT NULL,
    state disk.inactive_users_flow_state_type NOT NULL,
    start_time timestamp with time zone,
    update_time timestamp with time zone,
    debug_data jsonb,

    CONSTRAINT pk_inactive_users_flow PRIMARY KEY (uid)
);

CREATE INDEX ix_inactive_users_flow_state_start_time ON disk.inactive_users_flow (state, start_time);
