CREATE TABLE note (
    uid TEXT NOT NULL,
    id TEXT NOT NULL,
    last_revision BIGINT NOT NULL,
    mtime TIMESTAMP NOT NULL,
    delete_date TIMESTAMP,
    CONSTRAINT pk_note_id PRIMARY KEY (uid, id),
    CONSTRAINT check_revision CHECK (last_revision >= 0)
);

CREATE INDEX delete_date_note_idx on note(delete_date);
CREATE INDEX uid_note_idx on note(uid);

CREATE TABLE revision (
    uid TEXT NOT NULL,
    note_id TEXT NOT NULL,
    revision BIGINT NOT NULL,
    c_server_time TIMESTAMP NOT NULL DEFAULT now(),
    c_client_time TIMESTAMP NOT NULL,
    author_uid TEXT NOT NULL,
    delta jsonb,
    delta_mds_key TEXT,
    original_delta_mds_key TEXT,
    snapshot_mds_key TEXT,
    CONSTRAINT pk_delta_id PRIMARY KEY (uid, note_id, revision),
    CONSTRAINT fk_delta_note_id FOREIGN KEY (uid, note_id) REFERENCES note (uid, id)
);

CREATE TABLE request (
    uid TEXT NOT NULL,
    request_id TEXT,
    entity_id TEXT,
    revision BIGINT NOT NULL default 0,
    c_server_time TIMESTAMP NOT NULL DEFAULT now(),
    CONSTRAINT pk_request PRIMARY KEY (uid, request_id)
);

CREATE TABLE attachments (
    uid TEXT NOT NULL,
    note_id TEXT NOT NULL,
    c_revision BIGINT NOT NULL,
    d_revision BIGINT,
    path TEXT NOT NULL,
    CONSTRAINT pk_attachments_id PRIMARY KEY (uid, note_id, path)
--    CONSTRAINT fk_attachments_revision FOREIGN KEY (uid, note_id, c_revision) REFERENCES note (uid, id, last_revision)
);

CREATE INDEX attachments_uid_note_id_idx on attachments(uid, note_id);
