-- https://wiki.yandex-team.ru/users/arhipov/pg/disk/schema/#1.zaprosvsexmetadannyxfajjla/papkipoputiilifileid.infoinfobyfileidpublicinfo
-- Find parent element of the requested element,
-- and look it up both in disk.files and disk.folders.
-- Return all hierarchical info about found object.
-- If not found, returns an emtpy set.
CREATE OR REPLACE FUNCTION code.path_to_fid(
    in_path text,
    in_uid bigint
) RETURNS TABLE(type text, name text, fid uuid, parent_fid uuid) AS $$
DECLARE
    path text[] = string_to_array(trim(trailing '/' FROM in_path), '/');  -- Will have an empty array if in_path is '/'
    length int = array_length(path, 1);  -- Will be NULL if array has no elements.
    elem_parent_uuid uuid;
BEGIN
    IF length IS NULL  -- This must be a root node.
    THEN
        RETURN QUERY
            SELECT
                'file'::text AS type,
                '/'::text as name,
                dir.fid,
                dir.parent_fid
            FROM
                disk.folders AS dir
            WHERE
                dir.parent_fid IS NULL
                AND dir.uid = in_uid;
    END IF;

    WITH RECURSIVE  -- Not a root node.
    recurse AS (
        SELECT
            1 AS idx, dir.name, dir.parent_fid, dir.fid
        FROM
            disk.folders dir
        WHERE
            dir.parent_fid IS NULL
            AND dir.name = path[1]
            AND dir.uid = in_uid
    UNION
        SELECT
            idx + 1, child.name, child.parent_fid, child.fid
        FROM
            recurse parent join disk.folders child on parent.fid = child.parent_fid
        WHERE
            uid = in_uid
            AND
            child.name = path[idx + 1]
    )
    SELECT r.fid INTO elem_parent_uuid FROM recurse r WHERE r.name = path[length - 1] AND r.idx = (length - 1) LIMIT 1;  -- Parent with regards to elem_name (hence length - 1 expr)
    -- raise notice 'elem_name: %, elem_parent_uuid: %', path[length], elem_parent_uuid;
    RETURN QUERY
    SELECT 'file'::text AS type,
            f.name::text,
            f.fid,
            f.parent_fid
        FROM
            disk.files f
        WHERE
            uid = in_uid
        AND
            f.parent_fid = elem_parent_uuid
        AND
            f.name = path[length]
    UNION ALL
    SELECT 'dir'::text AS type,
            d.name::text,
            d.fid,
            d.parent_fid
        FROM
            disk.folders d
        WHERE
            uid = in_uid
        AND
            d.parent_fid = elem_parent_uuid
        AND
            d.name = path[length];
END
$$ LANGUAGE plpgsql STABLE;
