CREATE OR REPLACE FUNCTION code.trace_path(
    in_path text,
    in_uid bigint
) RETURNS TABLE(name text, fid uuid, parent_fid uuid) AS $$
DECLARE
    path text[] = string_to_array(trim(trailing '/' FROM in_path), '/');
    length int = array_length(path, 1);  -- Will be NULL if array has no elements.
BEGIN
    IF length IS NULL  -- This must be a root node.
    THEN
        RETURN QUERY
            SELECT
                'file'::text AS type,
                '/'::text as name,
                dir.fid,
                dir.parent_fid
            FROM
                disk.folders AS dir
            WHERE
                dir.parent_fid IS NULL
                AND dir.uid = in_uid;
    END IF;

    RETURN QUERY
    WITH RECURSIVE
    recurse AS (
        SELECT
            1 AS idx, dir.name, dir.parent_fid, dir.fid
        FROM
            disk.folders dir
        WHERE
            dir.parent_fid IS NULL
            AND dir.name = path[1]
            AND dir.uid = in_uid
    UNION
        SELECT
            idx + 1, child.name, child.parent_fid, child.fid
        FROM
            recurse parent join disk.folders child on parent.fid = child.parent_fid
        WHERE
            uid = in_uid
            AND
            child.name = path[idx + 1]
    )
    SELECT r.name::text, r.fid::uuid, r.parent_fid::uuid FROM recurse r;
END
$$ LANGUAGE plpgsql STABLE;
