CREATE OR REPLACE FUNCTION code.parent_fid_to_path(
    in_parent_fid uuid,
    in_uid bigint,
    in_name text
) RETURNS text AS $$
DECLARE
   result text;
BEGIN
    IF in_parent_fid IS NULL  -- A root node?
    THEN
        RETURN '/'::text AS path;
    END IF;

    WITH RECURSIVE
    recurse AS (
        SELECT
            0 as depth,
            in_name AS name,
            in_parent_fid AS parent_fid,
            NULL::uuid AS fid
        UNION ALL
        SELECT
            depth + 1, parent.name AS name, parent.parent_fid, parent.fid
        FROM
            recurse child join disk.folders parent on child.parent_fid = parent.fid
        WHERE
            uid = in_uid
        AND
            parent.parent_fid IS NOT NULL
    )
    SELECT '/' || array_to_string(
        array(
            SELECT name
            FROM recurse
            ORDER BY depth DESC
        ),
        '/',
        ''
    ) INTO result;
    RETURN result;
END
$$ LANGUAGE plpgsql STABLE;
