-- Find all parent folders of the element found by fid
-- and resolves path using parent folder names.
CREATE OR REPLACE FUNCTION code.fid_to_path(
    in_fid uuid,
    in_uid bigint
) RETURNS TABLE(type text, path text, fid uuid) AS $$
BEGIN
    RETURN QUERY
        WITH RECURSIVE r AS (
            SELECT 1 AS idx,
                   file.name AS relative_path,
                   file.name AS name,
                   file.parent_fid AS parent_fid,
                   'file' AS type_
              FROM disk.files AS file
             WHERE file.uid = in_uid
               AND file.fid = in_fid
             UNION ALL
            SELECT 1 AS idx,
                   dir.name AS relative_path,
                   dir.name AS name,
                   dir.parent_fid AS parent_fid,
                   'dir' AS type_
              FROM disk.folders AS dir
             WHERE dir.uid = in_uid
               AND dir.fid = in_fid
             UNION ALL
            SELECT idx + 1 AS idx,
                   parent.name || '/' || child.relative_path AS relative_path,
                   parent.name AS name,
                   parent.parent_fid AS parent_fid,
                   child.type_ AS type_
              FROM r child JOIN disk.folders parent ON child.parent_fid = parent.fid
             WHERE uid = in_uid
               AND parent.parent_fid IS NOT NULL
        )
        SELECT type_ AS type, '/' || relative_path AS path, in_fid as fid
          FROM r
         ORDER BY idx DESC LIMIT 1;
END
$$ LANGUAGE plpgsql STABLE;
