CREATE OR REPLACE FUNCTION code.paths_to_fids(
    in_paths text[],
    in_uid bigint
) RETURNS TABLE(type text, name text, path text, fid uuid, parent_fid uuid) AS $$
BEGIN
    RETURN QUERY
        SELECT r.type AS type,
               r.name AS name,
               in_path AS path,
               r.fid AS fid,
               r.parent_fid AS parent_fid
          FROM unnest(in_paths) AS in_path,
               LATERAL code.path_to_fid(in_path, in_uid) AS r;
END
$$ LANGUAGE plpgsql STABLE;
