-- 
-- Find parent element id of the requested by path element
CREATE OR REPLACE FUNCTION code.path_to_parent_fid(
    in_path text,
    in_uid bigint
) RETURNS uuid AS $$
DECLARE
    path text[] = string_to_array(trim(trailing '/' FROM in_path), '/');  -- Will have an empty array if in_path is '/'
    length int = array_length(path, 1);  -- Will be NULL if array has no elements.
    result uuid;
BEGIN
    IF length IS NULL  -- This must be a root node.
    THEN
        RETURN NULL;
    END IF;

    WITH RECURSIVE  -- Not a root node.
    recurse AS (
        SELECT
            1 AS idx, dir.name, dir.parent_fid, dir.fid
        FROM
            disk.folders dir
        WHERE
            dir.parent_fid IS NULL
            AND dir.name = path[1]
            AND dir.uid = in_uid
    UNION
        SELECT
            idx + 1, child.name, child.parent_fid, child.fid
        FROM
            recurse parent join disk.folders child on parent.fid = child.parent_fid
        WHERE
            uid = in_uid
            AND
            child.name = path[idx + 1]
    )
    SELECT r.fid INTO result FROM recurse r WHERE r.idx = (length - 1) LIMIT 1;
    RETURN result;
END
$$ LANGUAGE plpgsql STABLE;
