CREATE TABLE disk.last_files_cache (
    id             uuid   NOT NULL,
    uid            bigint NOT NULL,
    gid            uuid   NOT NULL,
    owner_uid      bigint NOT NULL,
    file_id        bytea  NOT NULL,
    file_date_modified  timestamp with time zone NOT NULL,
    date_created   timestamp with time zone NOT NULL,

    CONSTRAINT pk_last_files_cache PRIMARY KEY (id)
);

CREATE INDEX uk_last_files_cache_gid_uid
    ON disk.last_files_cache
 USING btree (gid, uid);

CREATE INDEX uk_last_files_cache_uid_file_date_modified
    ON disk.last_files_cache
 USING btree (uid, file_date_modified);
