CREATE INDEX ix_files_uid_id ON disk.files (uid, id);
CREATE INDEX ix_files_uid_media_type ON disk.files (uid, media_type);
CREATE INDEX ix_files_uid_date_uploaded ON disk.files (uid, date_uploaded);
CREATE INDEX ix_files_uid_date_modified ON disk.files (uid, date_modified);
CREATE INDEX ix_files_uid_parent_fid_date_modified_media_type ON disk.files (uid, parent_fid, date_modified, media_type);
CREATE INDEX ix_files_date_hidden_data ON disk.files (date_hidden_data);

CREATE INDEX ix_storage_files_stid ON disk.storage_files (stid);
CREATE INDEX ix_storage_files_digest_stid ON disk.storage_files (digest_stid);
CREATE INDEX ix_storage_files_preview_stid ON disk.storage_files (preview_stid);
CREATE INDEX ix_storage_files_size ON disk.storage_files (size);

CREATE INDEX ix_folders_uid_id ON disk.folders (uid, id);
CREATE INDEX ix_folders_uid_date_uploaded ON disk.folders (uid, date_uploaded);
CREATE INDEX ix_folders_uid_date_modified ON disk.folders (uid, date_modified);
CREATE INDEX ix_folders_uid_parent_fid_date_modified ON disk.folders (uid, parent_fid, date_modified);
CREATE INDEX ix_folders_date_hidden_data ON disk.folders (date_hidden_data);

CREATE INDEX ix_changelog_uid_version ON disk.changelog (uid, version);
CREATE INDEX ix_changelog_uid_gid_version ON disk.changelog (uid, gid, version);

CREATE INDEX ix_disk_info_uid_parent ON disk.disk_info (uid, parent);

CREATE INDEX ix_filesystem_locks_dtime ON disk.filesystem_locks (dtime);

CREATE INDEX ix_link_data_uid ON disk.link_data (uid);
CREATE INDEX ix_link_data_date_deleted ON disk.link_data (date_deleted);
CREATE INDEX ix_link_data_date_parent ON disk.link_data (parent);

CREATE INDEX ix_misc_data_file_stid ON disk.misc_data (file_stid);
CREATE INDEX ix_misc_data_digest_stid ON disk.misc_data (digest_stid);
CREATE INDEX ix_misc_data_preview_stid ON disk.misc_data (preview_stid);
CREATE INDEX ix_misc_data_uid_mediatype ON disk.misc_data (uid, mediatype);
CREATE INDEX ix_misc_data_uid_parent ON disk.misc_data (uid, parent);
CREATE INDEX ix_misc_data_uid_file_id ON disk.misc_data (uid, file_id);
CREATE INDEX ix_misc_data_hid ON disk.misc_data (hid);

CREATE INDEX ix_operations_uid_md5 ON disk.operations (uid, md5);
CREATE INDEX ix_operations_uid_state ON disk.operations (uid, state);
CREATE INDEX ix_operations_dtime ON disk.operations (dtime);

CREATE INDEX ix_user_index_yateam_uid ON disk.user_index (yateam_uid);
CREATE INDEX ix_user_index_b2b_key ON disk.user_index (b2b_key);
