CREATE TABLE disk.version_links (
    id uuid PRIMARY KEY,
    uid bigint  NOT NULL,
    file_id bytea NOT NULL,
    disk_path text,
    disk_path_hash uuid,
    date_created timestamp with time zone NOT NULL
);
CREATE UNIQUE INDEX uk_version_links_uid_file_id ON disk.version_links (uid, file_id);
CREATE INDEX ix_version_links_uid_disk_path_hash ON disk.version_links (uid, disk_path_hash);

CREATE TABLE disk.version_data(
    id uuid PRIMARY KEY,
    uid bigint NOT NULL,
    version_link_id uuid REFERENCES disk.version_links(id) ON DELETE NO ACTION,
    parent_version_id uuid,
    type text NOT NULL,
    date_created timestamp with time zone NOT NULL,
    is_checkpoint boolean NOT NULL DEFAULT true,
    folded_counter bigint NOT NULL DEFAULT 0,
    uid_created bigint NOT NULL,
    platform_created text NOT NULL,
    storage_id uuid REFERENCES disk.storage_files(storage_id) ON DELETE NO ACTION DEFERRABLE INITIALLY DEFERRED
);
CREATE INDEX ix_version_data_list ON disk.version_data (uid, version_link_id, date_created, is_checkpoint);
CREATE INDEX ix_version_data_storage_id ON disk.version_data (storage_id);
