CREATE OR REPLACE FUNCTION disk.process_resource_action() RETURNS TRIGGER AS $$
    BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO disk.resources_index (uid,fid,parent_fid,name) SELECT NEW.uid, NEW.fid, NEW.parent_fid, NEW.name;
            RETURN NEW;
        ELSIF (TG_OP = 'UPDATE') THEN
            UPDATE disk.resources_index SET uid=NEW.uid, fid=NEW.fid, parent_fid=NEW.parent_fid, name=NEW.name WHERE uid=OLD.uid AND fid=OLD.fid;
            RETURN NEW;
        ELSIF (TG_OP = 'DELETE') THEN
            DELETE FROM disk.resources_index WHERE uid=OLD.uid AND fid=OLD.fid;
            RETURN OLD;
        END IF;
        RETURN NULL; -- result is ignored since this is an AFTER trigger
    END;
$$ LANGUAGE plpgsql VOLATILE;


CREATE TRIGGER file_insert_trigger
AFTER INSERT ON disk.files
FOR EACH ROW
EXECUTE PROCEDURE disk.process_resource_action();

CREATE TRIGGER folder_insert_trigger
AFTER INSERT ON disk.folders
FOR EACH ROW
WHEN ( NEW.parent_fid IS NOT NULL )
EXECUTE PROCEDURE disk.process_resource_action();

CREATE TRIGGER file_update_trigger
AFTER UPDATE OF uid,fid,parent_fid,name ON disk.files
FOR EACH ROW EXECUTE PROCEDURE disk.process_resource_action();

CREATE TRIGGER folder_update_trigger
AFTER UPDATE OF uid,fid,parent_fid,name ON disk.folders
FOR EACH ROW EXECUTE PROCEDURE disk.process_resource_action();

CREATE TRIGGER file_delete_trigger
AFTER DELETE ON disk.files
FOR EACH ROW EXECUTE PROCEDURE disk.process_resource_action();

CREATE TRIGGER folder_delete_trigger
AFTER DELETE ON disk.folders
FOR EACH ROW EXECUTE PROCEDURE disk.process_resource_action();
