CREATE TYPE disk.additional_file_type AS enum (
    'live_video'
);

CREATE TABLE disk.additional_file_links (
    type disk.additional_file_type not null,
    uid bigint not null,
    main_file_fid uuid not null,
    additional_file_fid uuid not null,
    CONSTRAINT fk_files_1 FOREIGN KEY (uid, main_file_fid) REFERENCES disk.files(uid, fid) DEFERRABLE INITIALLY DEFERRED,
    CONSTRAINT fk_files_2 FOREIGN KEY (uid, additional_file_fid) REFERENCES disk.files(uid, fid) DEFERRABLE INITIALLY DEFERRED,
    CONSTRAINT uk_additional_file_links_uid_main_file_fid_type UNIQUE (uid, main_file_fid, type)
);

CREATE INDEX ix_additional_file_links_uid_main_file_fid ON disk.additional_file_links (uid, main_file_fid);
CREATE INDEX ix_additional_file_links_uid_additional_file_fid ON disk.additional_file_links (uid, additional_file_fid);

ALTER TABLE disk.files ADD COLUMN is_live_photo BOOLEAN;
