CREATE TYPE disk.platform_type AS enum (
    'android',
    'ios',
    'mac',
    'web',
    'windows',
    'search_app'
);

CREATE TABLE disk.user_activity_info (
    uid bigint NOT NULL,
    platform_type disk.platform_type NOT NULL,
    first_activity date NOT NULL,
    last_activity date NOT NULL,
    CONSTRAINT pk_user_activity_info PRIMARY KEY (uid, platform_type),
    CONSTRAINT fk_user_activity_info_uid FOREIGN KEY (uid) REFERENCES disk.user_index (uid) ON DELETE CASCADE DEFERRABLE INITIALLY DEFERRED,
    CONSTRAINT check_activity_values CHECK (last_activity >= first_activity)
);

