CREATE TABLE disk.source_ids (
    uid                           bigint  NOT NULL,
    storage_id                    uuid    NOT NULL,
    source_id                     text    NOT NULL,
    is_live_photo                 boolean NOT NULL,
    CONSTRAINT pk_source_ids PRIMARY KEY (uid, storage_id, is_live_photo, source_id)
);
CREATE INDEX uk_uid_source_id ON disk.source_ids USING btree (uid, source_id);

CREATE TABLE disk.deletion_log (
    uid                           bigint  NOT NULL,
    file_id                       bytea   NOT NULL,
    storage_id                    uuid    NOT NULL,
    deletion_log_revision         timestamp with time zone  NOT NULL DEFAULT current_timestamp, 
    is_live_photo                 boolean NOT NULL,
    CONSTRAINT pk_deletion_log PRIMARY KEY (uid, deletion_log_revision)
);
