CREATE TABLE disk.album_deltas (
    id uuid NOT NULL,
    uid bigint NOT NULL,
    revision bigint NOT NULL,
    changes jsonb NOT NULL,

    CONSTRAINT pk_album_deltas PRIMARY KEY (id)
);

CREATE INDEX ix_album_deltas_uid_revision ON disk.album_deltas (uid, revision);

CREATE TRIGGER album_deltas_guard_by_migration_lock
    AFTER INSERT OR UPDATE OR DELETE
    ON disk.album_deltas
    FOR EACH ROW
EXECUTE PROCEDURE disk.guard_by_migration_lock('uid');
