ALTER TABLE disk.album_items ADD COLUMN order_index_2 NUMERIC(32, 8);

CREATE OR REPLACE FUNCTION disk.process_album_items_action() RETURNS TRIGGER AS $$
    BEGIN
        NEW.order_index_2=NEW.order_index;
        RETURN NEW;
    END;
$$ LANGUAGE plpgsql VOLATILE;

CREATE TRIGGER album_items_update_order_index
BEFORE UPDATE ON disk.album_items
FOR EACH ROW
EXECUTE PROCEDURE disk.process_album_items_action();

CREATE TRIGGER album_items_insert_order_index
BEFORE INSERT ON disk.album_items
FOR EACH ROW
EXECUTE PROCEDURE disk.process_album_items_action();
