CREATE OR REPLACE FUNCTION
    check_uniq_pfid_name_files() RETURNS trigger AS
$check_uniq_pfid_name_files$
BEGIN
    IF (SELECT TRUE
        FROM disk.folders
        WHERE uid = NEW.uid
          AND name = NEW.name
          AND parent_fid = NEW.parent_fid
        LIMIT 1)
    THEN
        RAISE 'Duplicate child name: "%". Folder with the same name already exists. uid: "%", parent_fid: "%"', NEW.name, NEW.uid, NEW.parent_fid USING ERRCODE = 'unique_violation';
    END IF;
    RETURN NEW;
END;
$check_uniq_pfid_name_files$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION
    check_uniq_pfid_name_folders() RETURNS trigger AS
$check_uniq_pfid_name_folders$
BEGIN
    IF (SELECT TRUE
        FROM disk.files
        WHERE uid = NEW.uid
          AND name = NEW.name
          AND parent_fid = NEW.parent_fid
        LIMIT 1)
    THEN
        RAISE 'Duplicate child name: "%". File with the same name already exists. uid: "%", parent_fid: "%"', NEW.name, NEW.uid, NEW.parent_fid USING ERRCODE = 'unique_violation';
    END IF;
    RETURN NEW;
END;
$check_uniq_pfid_name_folders$ LANGUAGE plpgsql;

CREATE CONSTRAINT TRIGGER check_insert_uniq_pfid_name_files
    AFTER INSERT
    ON disk.files
    INITIALLY DEFERRED
    FOR EACH ROW
EXECUTE PROCEDURE check_uniq_pfid_name_files();

CREATE CONSTRAINT TRIGGER check_update_uniq_pfid_name_files
    AFTER UPDATE OF uid, parent_fid, name
    ON disk.files
    INITIALLY DEFERRED
    FOR EACH ROW
EXECUTE PROCEDURE check_uniq_pfid_name_files();

CREATE CONSTRAINT TRIGGER check_insert_uniq_pfid_name_folders
    AFTER INSERT
    ON disk.folders
    INITIALLY DEFERRED
    FOR EACH ROW
EXECUTE PROCEDURE check_uniq_pfid_name_folders();

CREATE CONSTRAINT TRIGGER check_update_uniq_pfid_name_folders
    AFTER UPDATE OF uid, parent_fid, name
    ON disk.folders
    INITIALLY DEFERRED
    FOR EACH ROW
EXECUTE PROCEDURE check_uniq_pfid_name_folders();
