CREATE TABLE disk.album_face_clusters (
    uid         bigint  NOT NULL,
    cluster_id  text    NOT NULL,
    album_id    bytea   NOT NULL,

    CONSTRAINT pk_album_face_clusters PRIMARY KEY (uid, cluster_id),
    CONSTRAINT fk_album_face_clusters_uid_album_id FOREIGN KEY (uid, album_id)
        REFERENCES disk.albums (uid, id)
        ON DELETE NO ACTION DEFERRABLE INITIALLY DEFERRED
);

CREATE INDEX ix_album_face_clusters_uid_album_id
    ON disk.album_face_clusters (uid, album_id);

CREATE TRIGGER album_face_clusters_guard_by_migration_lock
    AFTER INSERT OR UPDATE OR DELETE
    ON disk.album_face_clusters
    FOR EACH ROW
EXECUTE PROCEDURE disk.guard_by_migration_lock('uid');
