CREATE TABLE disk.task_queue (
    id            uuid                      NOT NULL  DEFAULT uuid_generate_v1(),
    uid           bigint                    NOT NULL,
    date_created  timestamp with time zone  NOT NULL  DEFAULT now(),
    task_name     text                      NOT NULL,
    task_data     jsonb                     NOT NULL,
    retry_count   bigint                    NOT NULL  DEFAULT 0,
    next_schedule timestamp with time zone  NOT NULL  DEFAULT now(),

    CONSTRAINT pk_task_queue PRIMARY KEY (id)
);

CREATE INDEX ix_task_queue_uid_date_created
    ON disk.task_queue (uid, retry_count, next_schedule);
