-- 1. Meta/info
SELECT
    f.fid, f.date_created, f.date_modified, f.name, 'file' as type, f.date_uploaded, s.date_origin
FROM
    disk.files f JOIN disk.storage_files s USING (storage_id)
    JOIN (SELECT fid FROM code.path_to_fid(%(path)s, %(uid)s)) q USING (fid)
WHERE f.uid = %(uid)s
UNION ALL
SELECT
    d.fid, d.date_created, d.date_modified, d.name, 'dir' as type, NULL, NULL
FROM
    disk.folders d JOIN (SELECT fid FROM code.path_to_fid(%(path)s, %(uid)s)) q ON q.fid = d.fid
WHERE d.uid = %(uid)s;

-- 2. list
SELECT
    d.fid, d.date_created, d.date_modified, d.date_created, d.name, 'dir' as type, NULL
FROM
    disk.folders d JOIN (SELECT fid FROM code.path_to_fid(%(path)s, %(uid)s)) q ON q.fid = d.parent_fid
WHERE d.uid = %(uid)s
UNION ALL
SELECT
    f.fid, f.date_created, f.date_modified, f.date_uploaded, f.name, 'file' as type, s.date_origin
FROM
    disk.files f JOIN (SELECT fid FROM code.path_to_fid(%(path)s, %(uid)s)) q ON q.fid = f.parent_fid
    JOIN disk.storage_files s USING (storage_id)
WHERE f.uid = %(uid)s;

-- 3. tree, fulltree
-- EXPLAIN (analyse, verbose, buffers, timing)
WITH RECURSIVE
recurse AS (
    SELECT fid FROM code.path_to_fid(%(path)s, %(uid)s)
UNION ALL
    SELECT
        c.fid
    FROM
        recurse p JOIN disk.folders c ON p.fid = c.parent_fid
    WHERE
        c.uid = %(uid)s
)
SELECT
    d.fid, d.date_created,
    d.date_modified, d.name,
    'dir' as type, NULL
FROM
    disk.folders d JOIN recurse r
        ON d.uid = %(uid)s
        AND d.fid = r.fid
UNION ALL
SELECT
    f.fid AS fid, f.date_created,
    f.date_modified, f.name,
    'file' AS type, s.date_origin
FROM
    disk.files f JOIN recurse r
        ON f.uid = %(uid)s
        AND f.parent_fid = r.fid
    JOIN disk.storage_files s
	USING (storage_id)
ORDER BY date_modified
LIMIT 1000;

-- 4. bulk_info_by_resource_ids
SELECT
    f.fid,
    f.date_created,
    f.date_modified,
    s.date_origin,
    f.name,
    code.parent_fid_to_path(f.parent_fid, f.uid, f.name) as path,
    'file' as type,
    s.date_uploaded
FROM
    disk.files f JOIN disk.storage_files s USING (storage_id)
WHERE
    f.uid = %(uid)s
    AND
    id IN (%(fid)s)
UNION ALL
SELECT
    d.fid,
    d.date_created,
    d.date_modified,
    NULL as date_origin,
    d.name,
    code.parent_fid_to_path(d.parent_fid, d.uid, d.name) as path,
    'dir' as type,
    date_uploaded
FROM
    disk.folders d
WHERE
    d.uid = %(uid)s
    AND
    id IN (%(fid)s);

-- 4.1 bulk_info_by_resource_ids limited by root (/disk, /trash)
SELECT * FROM (
    SELECT
        f.fid,
        f.date_created,
        f.date_modified,
        s.date_origin,
        f.name,
        code.parent_fid_to_path(f.parent_fid, f.uid, f.name) as path,
        'file' as type,
        s.date_uploaded
    FROM
        disk.files f JOIN disk.storage_files s USING (storage_id)
    WHERE
        f.uid = %(uid)s
        AND
        id IN (%(fid)s)
    UNION ALL
    SELECT
        d.fid,
        d.date_created,
        d.date_modified,
        NULL as date_origin,
        d.name,
        code.parent_fid_to_path(d.parent_fid, d.uid, d.name) as path,
        'dir' as type,
        date_uploaded
    FROM
        disk.folders d
    WHERE
        d.uid = %(uid)s
        AND
        id IN (%(fid)s)
) AS s WHERE s.path LIKE '/disk/%%';

-- 5. Bulk info
SELECT
    f.fid,
    f.date_created,
    f.date_modified,
    s.date_origin,
    f.name,
    code.parent_fid_to_path(f.parent_fid, f.uid, f.name) as path,
    'file' as type,
    s.date_uploaded
FROM
    disk.files f JOIN disk.storage_files s USING (storage_id)
WHERE
    f.uid = %(uid)s
    AND
    f.fid IN (%(fid)s)
UNION ALL
SELECT
    d.fid,
    d.date_created,
    d.date_modified,
    NULL,
    d.name,
    code.parent_fid_to_path(d.parent_fid, d.uid, d.name) as path, 'dir' as type,
    NULL AS date_uploaded
FROM
    disk.folders d
WHERE
    d.uid = %(uid)s
    AND
    d.fid IN (%(fid)s);
