CREATE TYPE job_status AS ENUM ('ready', 'starting', 'running', 'completed', 'failed', 'expired');

CREATE TABLE job (
  id UUID NOT NULL,
  task TEXT NOT NULL,
  
  active_uid TEXT,
  parameters JSONB NOT NULL,

  status job_status NOT NULL,
  
  schedule_time TIMESTAMP NOT NULL,
  priority INTEGER NOT NULL,

  worker_id TEXT,
  
  start_time TIMESTAMP,
  finish_time TIMESTAMP,
  cpu_usage SMALLINT,

  attempt INTEGER,
  error_message TEXT,
  error_stack_trace TEXT,
  
  PRIMARY KEY (id)
);

CREATE INDEX fetch_query_key on job (task, status, priority DESC, schedule_time) WHERE status = 'ready';
CREATE UNIQUE INDEX active_uid_key on job (active_uid) WHERE active_uid IS NOT NULL;
