CREATE TABLE cron_job (
    task TEXT NOT NULL,
    create_time TIMESTAMP NOT NULL,

    status job_status NOT NULL,

    worker_id TEXT,
    start_time TIMESTAMP,
    finish_time TIMESTAMP,

    cpu_usage SMALLINT,
    error_message TEXT,
    error_stack_trace TEXT,

    CONSTRAINT pk_cron_job PRIMARY KEY (task, create_time),
    CONSTRAINT check_task_length CHECK (char_length(task) <= 256)
);

CREATE TABLE cron_task (
    task TEXT NOT NULL,
    data JSONB NOT NULL,

    CONSTRAINT pk_cron_task PRIMARY KEY (task),
    CONSTRAINT check_task_length CHECK (char_length(task) <= 256)
);

CREATE TABLE cron_task_stats (
    task TEXT NOT NULL,
    stats JSONB NOT NULL,

    CONSTRAINT pk_cron_task_stats PRIMARY KEY (task),
    CONSTRAINT check_task_length CHECK (char_length(task) <= 256)
);
