CREATE OR REPLACE FUNCTION public.update_job_counters(i_limit integer DEFAULT 1000)
 RETURNS SETOF job_counters
 LANGUAGE sql
AS $$
    WITH batch AS (
        SELECT * FROM job_counters_queue
            LIMIT i_limit
            FOR UPDATE SKIP LOCKED
        ),
    deleted_rows AS (
        DELETE FROM job_counters_queue j
          USING batch b
          WHERE j.id = b.id
          RETURNING j.task, j.status, j.count_change
        ),
    summarized_change AS (
        SELECT task, status, sum(count_change) AS count_change
            FROM deleted_rows
          GROUP BY task, status
          HAVING sum(count_change) != 0
        )
    INSERT INTO job_counters
    SELECT task, status, count_change FROM summarized_change
    ON CONFLICT (task, status) DO UPDATE
    SET tasks_count = job_counters.tasks_count + excluded.tasks_count
    RETURNING *
$$;

SELECT * FROM public.update_job_counters(150000);

ALTER TABLE job_counters_queue ADD constraint pk_job_counters_queue PRIMARY KEY (id);
