CREATE OR REPLACE FUNCTION update_run_info_by_id_and_prev_status(
    i_partition INTEGER,
    i_id UUID,
    i_status job_status, i_worker_id TEXT,
    i_start_time TIMESTAMP, i_finish_time TIMESTAMP,
    i_prev_status job_status
) RETURNS BOOLEAN
LANGUAGE plpgsql VOLATILE AS $function$
BEGIN
    PERFORM acquire_jobs_partition(i_partition);

    UPDATE job
    SET status = i_status, worker_id = i_worker_id, start_time = i_start_time, finish_time = i_finish_time
    WHERE job.id = i_id AND job.status = i_prev_status;

    RETURN FOUND;
END
$function$;
