CREATE OR REPLACE FUNCTION find_job_by_id(
    i_partition INTEGER, i_id UUID
) RETURNS TABLE(
    id UUID, task TEXT, active_uid TEXT,
    parameters JSONB, create_time TIMESTAMP,
    schedule_time TIMESTAMP, priority INTEGER,
    attempt INTEGER, status job_status, worker_id TEXT,
    start_time TIMESTAMP, finish_time TIMESTAMP,
    cpu_usage SMALLINT, error_message TEXT, error_stack_trace TEXT
)
LANGUAGE plpgsql STABLE AS $function$
BEGIN
    PERFORM acquire_jobs_partition(i_partition);

    RETURN QUERY
    SELECT job.id, job.task, job.active_uid, job.parameters, job.create_time,
        job.schedule_time, job.priority, job.attempt, job.status, job.worker_id,
        job.start_time, job.finish_time, job.cpu_usage, job.error_message, job.error_stack_trace
    FROM job WHERE job.id = i_id;
END
$function$;
