CREATE TABLE albums (
    album_id INTEGER NOT NULL,
    user_id BIGINT NOT NULL,
    parent_id INTEGER,
    title TEXT,
    state INTEGER,
    description TEXT,
    access INTEGER,
    pwdhash TEXT,
    CONSTRAINT pk_albums_id PRIMARY KEY (album_id, user_id)
);

CREATE TABLE images (
    image_id INTEGER NOT NULL,
    album_id INTEGER NOT NULL,
    user_id BIGINT NOT NULL,
    orig_image_format INTEGER,
    filename TEXT,
    title TEXT,
    flags BIGINT,
    ph_storage_id INTEGER,
    dir_name TEXT NOT NULL,
    rnd INTEGER,
    access INTEGER,
    version INTEGER,
    extra_data BIGINT,
    state INTEGER,
    convert_state INTEGER,
    mpfs_path_found BOOLEAN,
    mpfs_path TEXT,
    CONSTRAINT pk_images_id PRIMARY KEY (image_id, dir_name),
    CONSTRAINT fk_images_albums_id FOREIGN KEY (album_id, user_id) REFERENCES albums (album_id, user_id)
);

CREATE INDEX user_id_image_id_index on images(user_id, image_id);
