CREATE TYPE container_state AS ENUM ('available', 'deactivated', 'lost');

CREATE TABLE containers (
    id text NOT NULL,
    pod_host text NOT NULL,
    service_port integer NOT NULL,
    location text NOT NULL,
    group_id text,
    state container_state,
    created_dt timestamp NOT NULL,
    modified_dt timestamp NOT NULL,
    sessions_count integer NOT NULL DEFAULT 0,

    PRIMARY KEY (id)
);

CREATE INDEX container_state_location_group_id ON containers(state, location, group_id, sessions_count);

CREATE TABLE sessions (
    id text NOT NULL,
    container_id text,
    finish_reason TEXT,
    finish_dt TIMESTAMP,
    created_dt TIMESTAMP NOT NULL,
    modified_dt TIMESTAMP NOT NULL,
    expiration_dt TIMESTAMP NOT NULL,

    PRIMARY KEY (id),
    CONSTRAINT fk_session_id_container_id FOREIGN KEY (container_id) REFERENCES containers (id)
);

CREATE INDEX session_container_id ON sessions (container_id);
CREATE INDEX session_container_id_finish_dt ON sessions (container_id, finish_dt);
CREATE INDEX session_expiration_dt_finish_dt ON sessions (expiration_dt, finish_dt);
CREATE INDEX session_finish_dt ON sessions (finish_dt);
