CREATE EXTENSION IF NOT EXISTS "uuid-ossp";

CREATE TABLE groups
(
    id                UUID      NOT NULL DEFAULT uuid_generate_v4(),
    group_type        TEXT      NOT NULL,
    group_external_id TEXT      NOT NULL,
    owner_uid         TEXT      NOT NULL,
    created_at        timestamp NOT NULL,
    updated_at        timestamp NOT NULL,
    payment_info      jsonb     NOT NULL,

    PRIMARY KEY (id)
);
CREATE UNIQUE INDEX group_uid_key on groups (group_type, group_external_id);

CREATE TABLE group_products
(
    id         UUID      NOT NULL DEFAULT uuid_generate_v4(),
    code       TEXT      NOT NULL,
    title      TEXT      NOT NULL,
    created_at timestamp NOT NULL,
    updated_at timestamp NOT NULL,

    PRIMARY KEY (id)
);
CREATE UNIQUE INDEX group_product_key on group_products (code);



CREATE TABLE group_services
(
    id                UUID      NOT NULL DEFAULT uuid_generate_v4(),
    group_id          UUID      NOT NULL,
    group_product_id  UUID      NOT NULL,
    deduplication_key TEXT      NULL,
    state             TEXT      NOT NULL,
    state_updated_at  timestamp NOT NULL,
    b_date            timestamp NOT NULL,
    created_at        timestamp NOT NULL,
    updated_at        timestamp NOT NULL,

    PRIMARY KEY (id),
    CONSTRAINT fk_groups FOREIGN KEY (group_id)
        REFERENCES groups ON DELETE CASCADE,
    CONSTRAINT fk_products FOREIGN KEY (group_product_id)
        REFERENCES group_products ON DELETE CASCADE
);

