/* pgmigrate-encoding: utf-8 */

CREATE TABLE user_products
(
    id         UUID      NOT NULL DEFAULT uuid_generate_v4(),
    code       TEXT      NOT NULL,
    title      TEXT      NOT NULL,
    created_at timestamp NOT NULL,
    updated_at timestamp NOT NULL,

    PRIMARY KEY (id)
);
CREATE UNIQUE INDEX user_product_key on user_products (code);

insert into user_products(id, code, title, created_at, updated_at)
values (uuid_generate_v4(), 'b2b_disk_2tb_v1', '2 терабайта', now(), now())
on conflict (code)
    DO UPDATE
    SET title      = excluded.title,
        updated_at = excluded.updated_at;



ALTER TABLE group_products
    ADD COLUMN user_product_id UUID NULL;

UPDATE group_products
SET user_product_id = (select id from user_products u where u.code = 'b2b_disk_2tb_v1')
where code = 'org_disk_2tb_v1';

ALTER TABLE group_products
    ADD CONSTRAINT fk_user_product FOREIGN KEY (user_product_id) REFERENCES user_products (id);

ALTER TABLE group_products
    ALTER COLUMN user_product_id SET NOT NULL;


CREATE TABLE features
(
    id         UUID      NOT NULL DEFAULT uuid_generate_v4(),
    code       TEXT      NOT NULL,
    created_at timestamp NOT NULL,
    updated_at timestamp NOT NULL,

    PRIMARY KEY (id)
);
CREATE UNIQUE INDEX features_key on features (code);

CREATE TABLE product_features
(
    id              UUID NOT NULL DEFAULT uuid_generate_v4(),
    user_product_id UUID NOT NULL,
    feature_id      UUID NOT NULL,

    PRIMARY KEY (id),
    CONSTRAINT fk_user_product FOREIGN KEY (user_product_id)
        REFERENCES user_products,
    CONSTRAINT fk_features FOREIGN KEY (feature_id)
        REFERENCES features
);


CREATE TABLE user_services
(
    id               UUID      NOT NULL DEFAULT uuid_generate_v4(),
    user_product_id  UUID      NOT NULL,
    uid              TEXT      NOT NULL,

    state            TEXT      NOT NULL,
    state_updated_at timestamp NOT NULL,
    next_check_date  timestamp NULL,

    created_at       timestamp NOT NULL,
    updated_at       timestamp NOT NULL,

    PRIMARY KEY (id),
    CONSTRAINT fk_user_products FOREIGN KEY (user_product_id)
        REFERENCES user_products
);

CREATE TABLE user_service_features
(
    id                 UUID      NOT NULL DEFAULT uuid_generate_v4(),
    user_service_id    UUID      NOT NULL,
    product_feature_id UUID      NOT NULL,

    state              TEXT      NOT NULL,
    state_updated_at   timestamp NOT NULL,

    created_at         timestamp NOT NULL,
    updated_at         timestamp NOT NULL,

    PRIMARY KEY (id),
    CONSTRAINT fk_user_services FOREIGN KEY (user_service_id)
        REFERENCES user_services,
    CONSTRAINT fk_product_features FOREIGN KEY (product_feature_id)
        REFERENCES product_features
);
