CREATE TABLE feature_callback_context
(
    id         uuid      NOT NULL DEFAULT uuid_generate_v4(),
    created_at timestamp NOT NULL,
    updated_at timestamp NOT NULL,
    uid        text      NOT NULL,
    feature_id uuid      NOT NULL,
    data       jsonb     NULL,

    PRIMARY KEY (id),
    CONSTRAINT fk_features FOREIGN KEY (feature_id)
        REFERENCES features ON DELETE CASCADE
);

CREATE UNIQUE INDEX feature_callback_context_uniq_ix on feature_callback_context (uid, feature_id);
