/* pgmigrate-encoding: utf-8 */
WITH mpfs(host) AS (SELECT case
                               when (select id IN ('0465e208-5abf-4b14-adb2-cb5e1ebf715e',
                                                   '6d6685f5-29ca-4b97-9268-bd21db35b0b1')
                                     from group_products where code = 'org_disk_2tb_v1')
                                   then 'mpfs.disk.yandex.net'
                               else 'mpfs-stable.dst.yandex.net'
                               end)
INSERT INTO features (code, created_at, updated_at, system_tvm_id, type, description, system_name,
                      activation_url_http_method, activation_url_template,
                      set_amount_url_http_method, set_amount_url_template,
                      deactivation_url_http_method, deactivation_url_template,
                      call_set_amount_on_activation, call_set_amount_on_deactivation)
VALUES ('mpfs_disk_space', now(), now(), null, 'additive', 'Предоставление места в Яндекс.Диске, измеряется в байтах', 'mpfs',
        'GET', 'https://' || (select host from mpfs) || '/billing/service_create?uid=#{uid}&line=partner&pid=yandex_disk_for_business&product.amount=#{amount}&auto_init_user=1&ip=127.0.0.1',
        'GET', 'https://' || (select host from mpfs) || '/billing/service_set_attribute?uid=#{uid}&sid=#{context.sid}&key=product.amount&value=#{amount}&ip=127.0.0.1',
        'GET', 'https://' || (select host from mpfs) || '/billing/service_delete?uid=#{uid}&sid=#{context.sid}&ip=127.0.0.1&send_email=0',
        false, true
       );

INSERT INTO product_features (user_product_id, feature_id, amount, created_at)
VALUES (
           (select id from user_products u where u.code = 'b2b_disk_2tb_v1'),
           (select id from features u where u.code = 'mpfs_disk_space'),
           2199023255552,
           now()
       );
