create table group_service_transactions
(
    billing_date     date    NOT NULL,
    group_service_id UUID    NOT NULL,
    amount           numeric NOT NULL,
    currency         TEXT    NOT NULL,

    PRIMARY KEY (billing_date, group_service_id),
    CONSTRAINT fk_group_service_id FOREIGN KEY (group_service_id) REFERENCES group_services (id)
);

CREATE INDEX group_service_transactions_group_service_id_ix ON group_service_transactions (group_service_id);


ALTER TABLE user_services
    ADD COLUMN first_feature_disabled_at timestamp NULL;

update user_services us
set first_feature_disabled_at = (
    select min(actual_disabled_at)
    from user_service_features usf
    where usf.target = 'disabled'
      and usf.status = 'actual'
      and usf.user_service_id = us.id
)
where target = 'disabled';

CREATE INDEX user_services__actual_enabled_at__ix ON user_services (actual_enabled_at);
CREATE INDEX user_services__first_feature_disabled_at__ix ON user_services (first_feature_disabled_at);

create table group_service_transaction_calculations
(
    billing_date               date      NOT NULL,
    updated_at                 TIMESTAMP NOT NULL,
    status                     text      NOT NULL,
    bazinga_calculation_job_id TEXT      NULL,

    PRIMARY KEY (billing_date)
);


alter table group_products
    add column balance_product_name text null;
update group_products
set balance_product_name = 'disk_b2b';
alter table group_products
    alter column balance_product_name set NOT NULL;

alter table group_products
    add column price numeric null;
update group_products
set price = 500;
alter table group_products
    alter column price set NOT NULL;

alter table group_products
    add column currency TEXT null;
update group_products
set currency = 'RUB';
alter table group_products
    alter column currency set NOT NULL;
