/* pgmigrate-encoding: utf-8 */
WITH mail(host, tvm) AS (SELECT case
                                    when (select id IN ('0465e208-5abf-4b14-adb2-cb5e1ebf715e',
                                                        '77290479-7a19-4415-99cf-439783f9f9d3')
                                          from group_products
                                          where code = 'org_disk_2tb_v1')
                                        then 'settings.mail.yandex.net'
                                    else 'settings-qa.mail.yandex.net'
                                    end,
                                case
                                    when (select id IN ('0465e208-5abf-4b14-adb2-cb5e1ebf715e',
                                                        '77290479-7a19-4415-99cf-439783f9f9d3')
                                          from group_products
                                          where code = 'org_disk_2tb_v1')
                                        then 2002474
                                    else 2002242
                                    end
)
INSERT
INTO features (code, created_at, updated_at, system_tvm_id, type, description, system_name,
               activation_url_http_method, activation_url_template, activation_body_template,
               set_amount_url_http_method, set_amount_url_template, set_amount_body_template,
               deactivation_url_http_method, deactivation_url_template, deactivation_body_template,
               call_set_amount_on_activation, call_set_amount_on_deactivation
               )
VALUES ('mail_ad_disabled', now(), now(), (select tvm from mail), 'toggleable', 'Отключение рекламы в Яндекс.Почте', 'mail',
        'POST', 'https://' || (select host from mail) || ':1580/update_params?uid=#{uid}', 'is_ad_disabled_via_billing=on',
        NULL, NULL, NULL,
        'POST', 'https://' || (select host from mail) || ':1580/update_params?uid=#{uid}', 'is_ad_disabled_via_billing=',
        false, false
        ),
       ('mail_priority_support', now(), now(), (select tvm from mail), 'toggleable', 'Приоритетная поддержка в Яндекс.Почте', 'mail',
        'POST', 'https://' || (select host from mail) || ':1580/update_params?uid=#{uid}', 'has_priority_support=on',
        NULL, NULL, NULL,
        'POST', 'https://' || (select host from mail) || ':1580/update_params?uid=#{uid}', 'has_priority_support=',
        false, false
       );

INSERT INTO user_products (code, title, created_at, updated_at)
VALUES ('b2b_mail_pro_v1', 'Отключение рекламы в почте, приоритетная поддержка', now(), now());

INSERT INTO group_products (code, title, created_at, updated_at, user_product_id, balance_product_name, price, currency)
VALUES ('org_mail_pro_v1', 'Отключение рекламы в почте, приоритетная поддержка', now(), now(),
        (select id from user_products where code = 'b2b_mail_pro_v1'), 'mail_b2b', 129, 'RUB');

INSERT INTO product_features (user_product_id, feature_id, amount, created_at)
VALUES ((select id from user_products where code = 'b2b_mail_pro_v1'), (select id from features where code = 'mail_ad_disabled'), 1, now()),
       ((select id from user_products where code = 'b2b_mail_pro_v1'), (select id from features where code = 'mail_priority_support'), 1, now());
