create table product_sets
(
    id         UUID      NOT NULL DEFAULT uuid_generate_v4(),
    key        TEXT      NOT NULL,
    created_at timestamp NOT NULL,

    PRIMARY KEY (id)
);
CREATE UNIQUE INDEX product_sets_key_ix on product_sets (key);


create table product_lines
(
    id             UUID      NOT NULL DEFAULT uuid_generate_v4(),
    product_set_id UUID      NOT NULL,
    created_at     timestamp NOT NULL,
    order_num      numeric   NOT NULL,

    PRIMARY KEY (id),
    CONSTRAINT fk_product_set FOREIGN KEY (product_set_id)
        REFERENCES product_sets ON DELETE CASCADE
);
CREATE INDEX product_lines_product_set_id_ix ON product_lines (product_set_id);


create table product_cards
(
    id         UUID      NOT NULL DEFAULT uuid_generate_v4(),
    created_at timestamp NOT NULL,

    PRIMARY KEY (id)
);


create table product_lines_to_product_cards
(
    product_line_id UUID    NOT NULL,
    product_card_id UUID    NOT NULL,
    order_num       numeric NOT NULL,

    PRIMARY KEY (product_line_id, product_card_id),
    CONSTRAINT fk_product_line FOREIGN KEY (product_line_id)
        REFERENCES product_lines ON DELETE CASCADE,

    CONSTRAINT fk_product_card FOREIGN KEY (product_card_id)
        REFERENCES product_cards ON DELETE CASCADE
);
CREATE INDEX product_lines_to_product_cards_product_card_id_ix ON product_lines_to_product_cards (product_card_id);


create table product_cards_to_user_products
(
    product_card_id UUID NOT NULL,
    user_product_id UUID NOT NULL,

    PRIMARY KEY (product_card_id, user_product_id),
    CONSTRAINT fk_user_product FOREIGN KEY (user_product_id)
        REFERENCES user_products ON DELETE CASCADE,

    CONSTRAINT fk_product_card FOREIGN KEY (product_card_id)
        REFERENCES product_cards ON DELETE CASCADE
);
CREATE INDEX product_cards_to_user_products_user_product_id_ix ON product_cards_to_user_products (user_product_id);
