create table tanker_keys
(
    id         UUID      NOT NULL DEFAULT uuid_generate_v4(),
    created_at timestamp not null,
    project    TEXT      NOT NULL,
    key_set    text      NOT NULL,
    key        text      not null,
    PRIMARY KEY (id)
);
CREATE UNIQUE INDEX tanker_keys_ix on tanker_keys (project, key_set, key);

create table tanker_translations
(
    tanker_key_id    UUID NOT NULL,
    locale           text not null,
    translation_text text null,

    CONSTRAINT fk_tanker_key FOREIGN KEY (tanker_key_id)
        REFERENCES tanker_keys ON DELETE CASCADE
);
CREATE UNIQUE INDEX tanker_translation_ix on tanker_translations (tanker_key_id, locale);

