create table user_product_prices
(
    id              UUID      NOT NULL DEFAULT uuid_generate_v4(),
    created_at      timestamp not null,
    user_product_id UUID      NOT NULL,
    region_id       text      NOT NULL,
    price           numeric   not null,
    currency        text      not null,

    primary key (id),
    CONSTRAINT fk_user_products FOREIGN KEY (user_product_id)
        REFERENCES user_products ON DELETE CASCADE

);
CREATE UNIQUE INDEX user_product_prices_ix on user_product_prices (user_product_id, region_id);


alter table user_services
    add column user_product_price_id uuid NULL;
alter table user_services
    add CONSTRAINT fk_user_product_prices FOREIGN KEY (user_product_price_id) REFERENCES user_product_prices;
CREATE INDEX user_products__user_product_prices_ix on user_services (user_product_price_id);

alter table user_products
    add column type text;
update user_products
set type = 'group';
alter table user_products
    alter column type set not null;

alter table user_products
    add column period text null;
