alter table user_product_prices
    add column period text not null;
drop index user_product_prices_ix;
CREATE UNIQUE INDEX user_product_prices__user_product_prices_period_idx on user_product_prices (user_product_id, region_id, period);



alter table user_products
    alter column period drop not null;
alter table user_products
    alter column period set default null;
alter table user_products
    alter column title drop not null;
alter table user_products
    alter column title set default null;


drop table product_cards_to_user_products;
drop table product_lines_to_product_cards;
drop table product_cards;

alter table user_products
    add column title_tanker_key_id UUID null;
alter table user_products
    add CONSTRAINT fk_title_tanker_key_id FOREIGN KEY (title_tanker_key_id) REFERENCES tanker_keys;
create index user_products_title_tanker_key_id_idx on user_products (title_tanker_key_id);

alter table user_products
    add column is_best_offer boolean default false NOT NULL;

create table user_products_to_product_lines
(
    product_line_id UUID    not null,
    user_product_id UUID    not null,
    order_num       numeric not null,

    PRIMARY KEY (product_line_id, user_product_id),
    CONSTRAINT fk_product_line FOREIGN KEY (product_line_id)
        REFERENCES product_lines ON DELETE CASCADE,

    CONSTRAINT fk_user_product FOREIGN KEY (user_product_id)
        REFERENCES user_products ON DELETE CASCADE
);
CREATE INDEX user_products_to_product_lines_user_product_id_ix ON user_products_to_product_lines (user_product_id);



create table product_owners
(
    id         UUID      not null DEFAULT uuid_generate_v4(),
    code       text      not null,
    created_at timestamp not null,
    PRIMARY KEY (id)
);
CREATE UNIQUE INDEX product_owners_code_ix on product_owners (code);

insert into product_owners(code, created_at)
values ('yandex_mail', now());

insert into product_owners(code, created_at)
values ('yandex_disk', now());


alter table user_products
    add column product_owner_id UUID NULL;
alter table user_products
    add constraint fk_user_products_product_owner_id foreign key (product_owner_id) references product_owners (id);
create index user_products_product_owner_id_idx on user_products (product_owner_id);

update user_products
set product_owner_id = (select id from product_owners where code = 'yandex_disk')
where code in ('b2b_disk_200gb_v1', 'b2b_disk_2tb_v1');

update user_products
set product_owner_id = (select id from product_owners where code = 'yandex_mail')
where code in ('b2b_mail_pro_v1');

alter table user_products
    alter column product_owner_id set not null;

