CREATE INDEX IF NOT EXISTS user_services_uid_ix ON user_services (uid);

create table orders
(
    id                    UUID      not null default uuid_generate_v4(),
    user_product_price_id UUID      not null,
    user_service_id       UUID      null,
    status                text      not null,
    uid                   text      not null,

    type                  text      not null,

    trust_order_id        text      not null,
    trust_amount          numeric   not null,
    trust_currency        text      not null,
    trust_error_message   text      null,
    trust_error_code      text      null,
    created_at            timestamp not null,
    updated_at            timestamp not null,

    primary key (id),
    CONSTRAINT fk_user_product_prices FOREIGN KEY (user_product_price_id)
        REFERENCES user_product_prices ON DELETE CASCADE,
    CONSTRAINT fk_user_services FOREIGN KEY (user_service_id)
        REFERENCES user_services ON DELETE CASCADE
);

create index order_user_product_price_idx on orders (user_product_price_id);
create index order_order_id_idx on orders (trust_order_id);
create index order_user_service_id_idx on orders (user_service_id);

alter table user_services
    add column auto_prolong_enabled boolean null;
create index user_services_next_check_date_ix on user_services (next_check_date) where target <> 'disabled';
alter table user_services
    add column billing_status text default null;

alter table user_products add column available_from timestamp null;
